# ABCgen
**Assumption-based cluster generator -- ABAFs with a clustered structure**

**ICCMA'25 version**

## Usage and input format
```
usage: abcgen.py [-h] -d DIRECTORY -i IDENTIFIER [-ra RULES_PER_ATOM] [-rs RULE_SIZE]
                              [-ctr CTR_PROBABILITY] [-c N_CLUSTERS] [-atm N_ATOMS] [-asm N_ASSUMPTIONS]
                              [-n N_INSTANCES] [--log_sccs | --no-log_sccs] [--seed SEED]

options:
  -h, --help                show this help message and exit
  -d DIRECTORY              directory for the benchmarks; required
  -i IDENTIFIER             identifier as prefix for instances; required
  -ra RULES_PER_ATOM,       maximum number of rules deriving each non-asmpt/contrary atom; default 3
  -rs RULE_SIZE             maximum size of rule bodies; default 2
  -ctr CTR_PROBABILITY      probability of a cluster deriving the contrary of an outside assumption; default 0.8
  -c N_CLUSTERS             default 20
  -atm N_ATOMS              number of non-assumption/contrary atoms in each cluster, default 20
  -asm N_ASSUMPTIONS        number of assumptions in each cluster; default 20
  -n N_INSTANCES            number of ABAFs generated for these parameter combinations, default 5
  --log_sccs                if on, print additional comment to end of line showing sizes of distinct SCCS
  --seed SEED               random seed for reproducibility
```

In particular, running
`python abcgen.py -d DIRECTORY -i IDENTIFIER --seed SEED`
will print 5 ABAFs in `DIRECTORY` with the default parameters, including decsription.txt listing the used parameters, `IDENTIFIER` and the random seed `SEED` used. 
For varied benchmarks, custom values for number of clusters as well as number of atoms and assumptions per cluster are good to set as well with the flags `-c`, `-atm`, and `-asm`.

The output is in the format [specificied for ICCMA 2025](https://argumentationcompetition.org/2025/rules.html#solver-requirements).

## Author of code
Tuomo Lehtonen, Aalto University. For questions or comments, contact tuomo.lehtonen@aalto.fi.

